/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.util.Mth;

public class ConfigDouble
extends ConfigBase<ConfigDouble>
implements IConfigDouble {
    public static final Codec<ConfigDouble> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PrimitiveCodec.STRING.fieldOf("name").forGetter(ConfigBase::getName), (App)PrimitiveCodec.DOUBLE.fieldOf("defaultValue").forGetter(get -> get.defaultValue), (App)PrimitiveCodec.DOUBLE.fieldOf("minValue").forGetter(get -> get.minValue), (App)PrimitiveCodec.DOUBLE.fieldOf("maxValue").forGetter(get -> get.maxValue), (App)PrimitiveCodec.DOUBLE.fieldOf("value").forGetter(get -> get.value), (App)PrimitiveCodec.BOOL.fieldOf("useSlider").forGetter(get -> get.useSlider), (App)PrimitiveCodec.STRING.fieldOf("comment").forGetter(get -> get.comment), (App)PrimitiveCodec.STRING.fieldOf("prettyName").forGetter(get -> get.prettyName), (App)PrimitiveCodec.STRING.fieldOf("translatedName").forGetter(get -> get.translatedName)).apply((Applicative)instance, ConfigDouble::new));
    private final double minValue;
    private final double maxValue;
    private final double defaultValue;
    private double value;
    private boolean useSlider;

    public ConfigDouble(String name, double defaultValue) {
        this(name, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigDouble(String name, double defaultValue, String comment) {
        this(name, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigDouble(String name, double defaultValue, String comment, String prettyName) {
        this(name, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE, comment, prettyName, name);
    }

    public ConfigDouble(String name, double defaultValue, String comment, String prettyName, String translatedName) {
        this(name, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE, comment, prettyName, translatedName);
    }

    public ConfigDouble(String name, double defaultValue, double minValue, double maxValue) {
        this(name, defaultValue, minValue, maxValue, false, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigDouble(String name, double defaultValue, double minValue, double maxValue, String comment) {
        this(name, defaultValue, minValue, maxValue, false, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigDouble(String name, double defaultValue, double minValue, double maxValue, String comment, String prettyName) {
        this(name, defaultValue, minValue, maxValue, false, comment, prettyName, name);
    }

    public ConfigDouble(String name, double defaultValue, double minValue, double maxValue, String comment, String prettyName, String translatedName) {
        this(name, defaultValue, minValue, maxValue, false, comment, prettyName, translatedName);
    }

    public ConfigDouble(String name, double defaultValue, double minValue, double maxValue, boolean useSlider) {
        this(name, defaultValue, minValue, maxValue, useSlider, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigDouble(String name, double defaultValue, double minValue, double maxValue, boolean useSlider, String comment) {
        this(name, defaultValue, minValue, maxValue, useSlider, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigDouble(String name, double defaultValue, double minValue, double maxValue, boolean useSlider, String comment, String prettyName) {
        this(name, defaultValue, minValue, maxValue, useSlider, comment, prettyName, name);
    }

    public ConfigDouble(String name, double defaultValue, double minValue, double maxValue, boolean useSlider, String comment, String prettyName, String translatedName) {
        super(ConfigType.DOUBLE, name, comment, prettyName, translatedName);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.useSlider = useSlider;
    }

    private ConfigDouble(String name, Double defaultValue, Double minValue, Double maxValue, Double value, Boolean useSlider, String comment, String prettyName, String translatedName) {
        this(name, defaultValue, minValue, maxValue, useSlider, comment, prettyName, translatedName);
        this.value = value;
    }

    @Override
    public boolean shouldUseSlider() {
        return this.useSlider;
    }

    @Override
    public void toggleUseSlider() {
        this.useSlider = !this.useSlider;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public double getDefaultDoubleValue() {
        return this.defaultValue;
    }

    @Override
    public void setDoubleValue(double value) {
        double oldValue = this.value;
        this.value = this.getClampedValue(value);
        if (oldValue != this.value) {
            this.onValueChanged();
        }
    }

    @Override
    public double getMinDoubleValue() {
        return this.minValue;
    }

    @Override
    public double getMaxDoubleValue() {
        return this.maxValue;
    }

    protected double getClampedValue(double value) {
        return Mth.clamp((double)value, (double)this.minValue, (double)this.maxValue);
    }

    @Override
    public boolean isModified() {
        return this.value != this.defaultValue;
    }

    @Override
    public boolean isModified(String newValue) {
        try {
            return Double.parseDouble(newValue) != this.defaultValue;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public void resetToDefault() {
        this.setDoubleValue(this.defaultValue);
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.value);
    }

    @Override
    public String getDefaultStringValue() {
        return String.valueOf(this.defaultValue);
    }

    @Override
    public void setValueFromString(String value) {
        try {
            this.setDoubleValue(Double.parseDouble(value));
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to set config value for {} from the string '{}'", (Object)this.getName(), (Object)value, (Object)e);
        }
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.setDoubleValue(this.getClampedValue(element.getAsDouble()));
            } else {
                MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        return new JsonPrimitive((Number)this.value);
    }
}

